  /*
   *  Object %name    : parser_atp_sst_special_data.c%
   *  State           :  %state%
   *  Creation date   :  Apr 06 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the DH parsing functions  
   *
   *  \version parser_atp_sst_special_data.c#1:csrc:1
   *  \author  taniam
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************* Include Files ****************/
#include "SST_SEP_ATP_SpecialData.h"
#include "SST_SEP_ATP_SpecialDataOpHMAC.h"
#include "SST_SEP_ATP_SpecialDataOpRSA.h"
#include "parser_atp_sst_special_data.h"
#include "sep_utils.h"

/************************ Global Data ************************/

 TST_ATP_SpecialDataOpAESTestDataStruct*   TST_ATP_SpecialDataOpAESTestData;
 TST_ATP_SpecialDataOpDESTestDataStruct*   TST_ATP_SpecialDataOpDESTestData;
 TST_ATP_SpecialDataOpHMACTestDataStruct*  TST_ATP_SpecialDataOpHMACTestData;
 TST_ATP_SpecialDataOpRSATestDataStruct*   TST_ATP_SpecialDataOpRSATestData;
extern DxUint8_t*      GlobalMemBuff;
extern DxUint8_t*       CurrGlobalMemBuff;

/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_SST_SpecialDataOpAES
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application 
* of the insertion, generation, reading, deletion, and usage of an AES symmetric key.
*
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/

DxUint32_t DX_SEP_SST_PARSER_SpecialDataOpAES(DxUint32_t* msg)
{
     /********* Variables Definitions ************/
     DxUint32_t    SEP_Error = DX_SUCCESS;

    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;

    /* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_SpecialDataOpAESTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_SpecialDataOpAESTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_SpecialDataOpAESTestData = (TST_ATP_SpecialDataOpAESTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_SpecialDataOpAESTestDataStruct);
    }




     /* 4. extract parameters from the message */
     /******************************************/
     DX_VOS_FastMemCpy(&TST_ATP_SpecialDataOpAESTestData[0],
                       &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET],
                       sizeof(TST_ATP_SpecialDataOpAESTestDataStruct));


      /* 5. call QA SEP function */
     /***************************/
      SEP_Error = SEPQA_SST_SpecialDataOpAES();
      SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_SpecialDataOpAES");

End:
     /* 6. Free allocated buffers */
//    DX_VOS_MemFree(TST_ATP_SpecialDataOpAESTestData);
    DX_VOS_MemFree(GlobalMemBuff);

     /* 5. end SEP message and return */
     /**********************/
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_SpecialDataAES_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);

}

/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_SST_SpecialDataOpDES
*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* This function does the parsing for the external application 
* of insertion, generation, reading, deletion, and usage of an DES symmetric key
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/

DxUint32_t DX_SEP_SST_PARSER_SpecialDataOpDES(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxUint32_t    SEP_Error = DX_SUCCESS;

    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;

    /* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                 &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_SpecialDataOpDESTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_SpecialDataOpDESTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_SpecialDataOpDESTestData = (TST_ATP_SpecialDataOpDESTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_SpecialDataOpDESTestDataStruct);
    }


     /*4. extract parameters from the message */
     /******************************************/
     DX_VOS_FastMemCpy(&TST_ATP_SpecialDataOpDESTestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_ATP_SpecialDataOpDESTestDataStruct));


    /*5. call QA SEP function */
    /***************************/
    SEP_Error = SEPQA_SST_SpecialDataOpDES();
    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_SpecialDataOpAES");

End:
    /*6. Free allocated buffers */
    DX_VOS_MemFree(GlobalMemBuff);
    /* 7. end SEP message and return */
    /**********************/
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_SpecialDataDES_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);

}

/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_SST_SpecialDataOpHMAC
*
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* Test the insertion, generation, reading, deletion, and usage of a HMAC key.
*
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/

DxUint32_t DX_SEP_SST_PARSER_SpecialDataOpHMAC(DxUint32_t* msg)
{
    /********* Variables Definitions ************/
    DxUint32_t    SEP_Error = DX_SUCCESS;

    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;

    /* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_SpecialDataOpHMACTestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_SpecialDataOpHMACTestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_SpecialDataOpHMACTestData = (TST_ATP_SpecialDataOpHMACTestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_SpecialDataOpHMACTestDataStruct);
    }


     //TST_ATP_SpecialDataOpHMACTestData = DX_VOS_MemMalloc(sizeof(TST_ATP_SpecialDataOpHMACTestDataStruct));
     //if (TST_ATP_SpecialDataOpHMACTestData == DX_NULL)
     //{
     //     SEP_Error = TST_CheckErrorReturn(TESTFAIL,"DX_VOS_MemMalloc - TST_ATP_SpecialDataOpHMACTestDataStruct ");
     //     goto End;
     //}


    /* 4. extract parameters from the message */
    /******************************************/
    DX_VOS_FastMemCpy(&TST_ATP_SpecialDataOpHMACTestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_ATP_SpecialDataOpHMACTestDataStruct));


    /* 5. call QA SEP function */
    /***************************/
    SEP_Error = SEPQA_SST_SpecialDataOpHMAC();
    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_SpecialDataOpHMAC");
    
  End:
    /* 6. Free allocated buffers */
//    DX_VOS_MemFree(TST_ATP_SpecialDataOpHMACTestData);
    DX_VOS_MemFree(GlobalMemBuff);
    /* 7. end SEP message and return */
    /**********************/
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_SpecialDataHMAC_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);

}

/*****************************************************************************
* Function Name:
*  DX_SEP_PARSER_SST_SpecialDataOpRSA
*
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  DxUint32_t - Function error return
*
* Description:
* Test the insertion, generation, reading, deletion, and usage of a HMAC key.
*
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams
* 2. allocate memory for GlobalMemBuff for all next needed allocation in the test
* 3. allocate buffer from GlobalMemBuff to data struct
* 4. extract parameters from the message 
* 5. call QA SEP function
* 6. free allocated GlobalMemBuff
* 7. end SEP message and return
******************************************************************************/

DxUint32_t DX_SEP_SST_PARSER_SpecialDataOpRSA(DxUint32_t* msg)
{
     /********* Variables Definitions ************/
     DxUint32_t    SEP_Error = DX_SUCCESS;
    GlobalMemBuff = DX_NULL;
    CurrGlobalMemBuff = DX_NULL;
    TST_Workspace = DX_NULL;

    /* 1. call to DX_SEP_MNG_SSTGetWorkspaceParams*/
    SEP_Error = DX_SEP_MNG_SSTGetWorkspaceParams(&TST_Workspace,
                                                &TST_WorkspaceSizeInBytes);

    if (TST_Workspace == DX_NULL)
     {
        TST_CheckErrorReturn(SEP_Error,"DX_SEP_MNG_SSTGetWorkspaceParams");
        goto End;
     }

    /*2. allocate memory for GlobalMemBuff for all next needed allocation in the test*/
    GlobalMemBuff = DX_VOS_MemMalloc(sizeof(DxUint8_t)*TST_MAX_SEP_WORKSPACE_MEM);

    if (GlobalMemBuff == DX_NULL)
     {
        TST_CheckErrorReturn(1,"DX_VOS_MemMalloc GlobalMemBuff");
        goto End;
     }
    CurrGlobalMemBuff = GlobalMemBuff;

    /*3. allocate buffer from GlobalMemBuff to data struct*/
    if  ((CurrGlobalMemBuff+sizeof(TST_ATP_SpecialDataOpRSATestDataStruct))>(GlobalMemBuff+TST_MAX_SEP_WORKSPACE_MEM))
    {
        TST_CheckErrorReturn(1,"TST_ATP_SpecialDataOpRSATestData memory allocation");
        goto End;
    }
    else
    {
        TST_ATP_SpecialDataOpRSATestData = (TST_ATP_SpecialDataOpRSATestDataStruct*)CurrGlobalMemBuff;
        CurrGlobalMemBuff = CurrGlobalMemBuff+sizeof(TST_ATP_SpecialDataOpRSATestDataStruct);
    }



     //TST_ATP_SpecialDataOpRSATestData = DX_VOS_MemMalloc(sizeof(TST_ATP_SpecialDataOpRSATestDataStruct));
     //if (TST_ATP_SpecialDataOpRSATestData == DX_NULL)
     //{
     //     SEP_Error = TST_CheckErrorReturn(TESTFAIL,"DX_VOS_MemMalloc - TST_ATP_SpecialDataOpRSATestDataStruct ");
     //     goto End;
     //}


    /* 4. extract parameters from the message */
    /******************************************/
    DX_VOS_FastMemCpy(&TST_ATP_SpecialDataOpRSATestData[0], &msg[DX_SEP_HOST_SEP_BASE_MSG_OFFSET], sizeof(TST_ATP_SpecialDataOpRSATestDataStruct));


    /* 5. call QA SEP function */
    /***************************/
    SEP_Error = SEPQA_SST_SpecialDataOpRSA();
    SEP_Error = TST_CheckErrorReturn(SEP_Error,"SEPQA_SST_SpecialDataOpRSA");
    
  End:
    /* 6. Free allocated buffers */
   // DX_VOS_MemFree(TST_ATP_SpecialDataOpRSATestData);
    DX_VOS_MemFree(GlobalMemBuff);
    /* 7. end SEP message and return */
    /**********************/
    msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_OP_CODE_OFFSET] = DX_SEP_HOST_SEP_PROTOCOL_SST_SpecialDataRSA_OP_CODE;
    return DX_SEP_EndMessage(msg, SEP_Error, 4);

}


